# Site Index

Lightweight, privacy-friendly analytics for WordPress that keeps all data in your database. Track visits, clicks, scroll depth, user journeys, and traffic sources with a beautiful Tailwind dashboard. No external services, no cookies - just simple, self-hosted visitor insights.

---

=== Kantan Analytics ===
Contributors: Kinda Useful Plugins
Tags: analytics, tracking, statistics, visitors, privacy, heatmap, user journey
Requires at least: 5.0
Tested up to: 6.7
Stable tag: 2.0.2
Requires PHP: 7.0
License: GPLv2 or later
License URI: https://www.gnu.org/licenses/gpl-2.0.html

Lightweight, self-hosted analytics with click tracking, scroll depth, and user journey visualization.

== Description ==

Kantan Analytics provides simple, privacy-friendly visitor tracking without external services or cookies. All data stays in your WordPress database.

Features:

* Visitor tracking with unique session-based visits
* Accurate time-on-site measurement
* Automatic traffic source categorization (organic, direct, social, referral)
* Bounce rate calculation
* Referrer tracking
* Top pages reporting
* **NEW: Click tracking with heatmap regions**
* **NEW: Scroll depth tracking**
* **NEW: User journey tracking (page-by-page navigation)**
* **NEW: Page transition flow analysis**
* **NEW: Entry and exit page tracking**
* **NEW: Automatic data cleanup (90-day retention)**
* Beautiful Tailwind CSS dashboard with Chart.js visualizations
* Time period filters (7/30/90/365 days)

What Gets Tracked:

* Session ID (browser session storage, not cookies)
* Page URL and title
* Referrer URL and traffic source
* Visit duration (updated every 30 seconds)
* Bounce status
* Screen dimensions
* Basic visitor info (user agent, IP)
* Click positions (percentage-based for cross-device consistency)
* Scroll depth (0-100%)
* Page navigation sequence within sessions

== Installation ==

1. Upload the plugin folder to the `/wp-content/plugins/` directory
2. Activate the plugin through the 'Plugins' menu in WordPress
3. The database table is created automatically on activation
4. View your analytics at Analytics in the admin menu

== Frequently Asked Questions ==

= Does this use cookies? =

No. Kantan Analytics uses browser sessionStorage only, which is cleared when the browser closes.

= Where is the data stored? =

All data is stored in your WordPress database in the `wp_kantan_analytics` table. Nothing is sent to external servers.

= How is traffic source detected? =

The plugin automatically categorizes traffic:
* Organic: Google, Bing, Yahoo, DuckDuckGo, Baidu
* Social: Facebook, Twitter, Instagram, LinkedIn, Pinterest, TikTok
* Referral: Other external sites
* Direct: No referrer or same domain

= Does this slow down my site? =

No. The tracking script loads asynchronously after page content and has minimal performance impact.

== Changelog ==

= 2.0.2 =
* Auto-update support

= 2.0.1 =
* Added tabbed navigation to dashboard (Overview, Interactions, Journeys)
* Improved dashboard organization and reduced page length
* Tab state preserved when changing time periods

= 2.0.0 =
* NEW: Click tracking with 3x3 region heatmap visualization
* NEW: Scroll depth tracking (0-100%) with distribution chart
* NEW: User journey tracking - see page-by-page navigation paths
* NEW: Page transition flow analysis (from page → to page)
* NEW: Entry and exit page tracking
* NEW: Top clicked elements report
* NEW: Automatic daily cleanup with 90-day retention (configurable via filter)
* Added new database tables: wp_kantan_clicks, wp_kantan_pageviews
* Updated dashboard with new visualization sections
* Improved tracking script with click buffering and scroll monitoring

= 1.0.0 =
* Initial release
* Core tracking functionality
* Admin dashboard with Tailwind CSS
* Chart.js visualizations
* Time period filters

== License ==

This plugin is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 2 of the License, or (at your option) any later version.

This plugin is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
