<?php

/**
 * Admin Dashboard
 * Adds admin menu and displays analytics dashboard
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

/* Add admin menu item */
function kantan_analytics_menu() {
    add_menu_page(
        'Kantan Analytics',              // Page title
        'Analytics',                      // Menu title
        'manage_options',                 // Capability
        'kantan-analytics',               // Menu slug
        'kantan_analytics_dashboard_page', // Callback function
        'dashicons-chart-line',           // Icon
        26                                // Position
    );
}
add_action('admin_menu', 'kantan_analytics_menu');

/* Dashboard page callback */
function kantan_analytics_dashboard_page() {
    // Get analytics data
    $days = isset($_GET['days']) ? intval($_GET['days']) : 30;
    $total_visits = kantan_get_total_visits($days);
    $avg_duration = kantan_get_avg_duration($days);
    $bounce_rate = kantan_get_bounce_rate($days);
    $traffic_sources = kantan_get_traffic_sources($days);
    $top_referrers = kantan_get_top_referrer_domains($days);
    $visits_by_day = kantan_get_visits_by_day($days);
    $top_pages = kantan_get_top_pages($days);

    // Calculate organic vs search
    $organic_count = 0;
    $search_count = 0;
    foreach ($traffic_sources as $source) {
        if ($source->traffic_source === 'organic') {
            $organic_count = $source->visits;
        }
    }
    $search_count = $total_visits - $organic_count;

    // Click tracking data
    $click_regions = kantan_get_click_regions($days);
    $total_clicks = kantan_get_total_clicks($days);
    $top_clicked_elements = kantan_get_top_clicked_elements($days, 5);
    $pages_with_clicks = kantan_get_pages_with_clicks($days, 10);

    // Journey tracking data
    $session_journeys = kantan_get_session_journeys($days, 10);
    $page_transitions = kantan_get_page_transitions($days, 10);
    $entry_pages = kantan_get_entry_pages($days, 5);
    $exit_pages = kantan_get_exit_pages($days, 5);

    // Scroll depth data
    $avg_scroll_depth = kantan_get_avg_scroll_depth($days);
    $scroll_distribution = kantan_get_scroll_distribution('', $days);

    // Include dashboard template
    include KANTAN_ANALYTICS_PLUGIN_DIR . 'templates/dashboard.php';
}

/* Enqueue admin styles */
function kantan_analytics_admin_assets($hook) {
    // Only load on our plugin page
    if ($hook !== 'toplevel_page_kantan-analytics') {
        return;
    }

    // Enqueue Tailwind CSS from CDN
    wp_enqueue_script('tailwindcss', 'https://cdn.tailwindcss.com', array(), null, false);

    // Enqueue Chart.js from CDN
    wp_enqueue_script('chartjs', 'https://cdn.jsdelivr.net/npm/chart.js', array(), null, true);
}
add_action('admin_enqueue_scripts', 'kantan_analytics_admin_assets');
