# Site Index

Resolves ACF/ACFE sync conflicts after pulling a production database by clearing database-stored field groups, forcing ACF to load from your local PHP files instead.

---

=== Fix ACF Sync ===
Contributors: Kinda Useful Plugins
Tags: acf, advanced custom fields, acfe, sync, database
Requires at least: 5.0
Tested up to: 6.7
Stable tag: 1.1.0
Requires PHP: 7.0
License: GPLv2 or later
License URI: https://www.gnu.org/licenses/gpl-2.0.html

Fix ACF sync conflicts after pulling a production database.

== Description ==

Fix ACF Sync solves a common development workflow problem: when you pull a production database locally, ACF field groups in the database have different `modified` timestamps than your local PHP files. ACF compares these timestamps and treats the database version as authoritative, causing your local changes to be ignored or overwritten.

**The Problem:**

* Your local sync files (`acf-json/` or `acfe-php/`) have the correct field definitions
* But your site displays the old (production) field configuration
* Clicking "Save" on a field group **overwrites your local files** with the old DB version

**The Solution:**

This plugin provides a simple admin interface to clear all ACF field groups and fields from the database. Once cleared, ACF will detect no database records exist and load entirely from your local sync files.

**Features:**

* One-click clearing of ACF database records
* Auto-sync option to immediately import local files (JSON and PHP) after clearing
* Shows current count of field groups and fields in database
* Clear success confirmation with deletion counts
* Safe: requires confirmation before deletion
* Secure: nonce verification and capability checks

== Installation ==

1. Upload the plugin folder to the `/wp-content/plugins/` directory
2. Activate the plugin through the 'Plugins' menu in WordPress
3. Navigate to Tools > Fix ACF Sync

== Frequently Asked Questions ==

= When should I use this? =

Use this tool immediately after pulling a production database to your local development environment, before opening the ACF dashboard.

= Will this delete my field group PHP files? =

No. This only deletes the database records. Your PHP files in `acfe-php/` or `acf-json/` remain untouched.

= Does this require ACF Pro? =

This plugin works with both ACF Free and ACF Pro, as well as ACF Extended (ACFE).

= Is this safe to use in production? =

This tool is designed for local development environments. Using it in production would remove all ACF field definitions from the database.

== Changelog ==

= 1.1.0 =
* Add auto-sync option to import local field groups (acf-json and acfe-php) after clearing database

= 1.0.0 =
* Initial release

== License ==

This plugin is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 2 of the License, or (at your option) any later version.

This plugin is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

== Trademarks ==

Advanced Custom Fields and ACF are trademarks of WP Engine, Inc. ACF Extended (ACFE) is a product of ACF Extended. This plugin is not affiliated with, endorsed by, or sponsored by WP Engine, the Advanced Custom Fields team, or ACF Extended.
